<?php

namespace app\admin\controller;

use app\common\controller\Backend;
use think\db;
/**
* 上分审核管理
*
* @icon fa fa-circle-o
*/
class Dotop extends Backend
{

    /**
    * Dotop模型对象
    * @var \app\admin\model\Dotop
    */
    protected $model = null;

    public function _initialize() {
        parent::_initialize();
        $this->model = new \app\admin\model\Dotop;
        $this->view->assign("statusList", $this->model->getStatusList());
        $this->view->assign("statusLists", $this->model->getStatusLists());
    }

    /**
    * 查看
    */
    public function index() {
        //当前是否为关联查询
        $this->relationSearch = true;
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if ($this->request->isAjax()) {
            //如果发送的来源是Selectpage，则转发到Selectpage
            if ($this->request->request('keyField')) {
                return $this->selectpage();
            }
            list($where, $sort, $order, $offset, $limit) = $this->buildparams();
            //   dump($_SESSION['think']['admin']);die;
            if ($_SESSION['think']['admin']['id'] == 1) {


                $list = $this->model
                ->where($where)
                   ->where("type", 0)
                ->order($sort, $order)
                ->paginate($limit);
                
                
                $cz = $this->model
                ->where($where)
                ->where("type", 0)
                 ->where("status", 1)
                ->sum("money");
                
                

            } else {

                $list = $this->model
                ->where($where)
                ->where("type", 0)
                ->where("dai_id", $_SESSION['think']['admin']['user_id'])

                ->order($sort, $order)
                ->paginate($limit);
                
                 $cz = $this->model
                ->where($where)
                ->where("type", 0)
                ->where("status", 1)
                 ->where("dai_id", $_SESSION['think']['admin']['user_id'])
                ->sum("money");



            }
            
            

            foreach ($list as $k => $row) {

                if ($row->type == 0) {
                    $row->moneys = ($row->money*5);
                } else {
                    $row->moneys = ($row->money/5);
                }

            }
            $result = array("total" => $list->total(), "rows" => $list->items(), "cz" => $cz, "info" => $_SESSION['think']['admin']['id']);
            return json($result);
        }
        return $this->view->fetch();
    }


    //充值操作
    public function accesss() {

        $params = $this->request->post();

        $member = db::table('fa_user')->where('id', $params['uid'])->find();

        if ($params['range'] == 0) {
            $wheres = "setinc";
            $info = "pontuado com sucesso".$params['money'];
        } else {
            if ($member['money'] < $params['money']) {
                $this->error('余额不足，不能扣取');
            }
            $info = "Sucesso".$params['money'];
            $wheres = "setdec";
        }
        $result = false;
        // dump($member['gec']);die;
        Db::startTrans();
        try {
            db::table('fa_user')->where('id', $params['uid'])->$wheres("money", $params['money']);
            //是否采用模型验证
            $result = db::name('mx')->insert([
                'uid' => $params['uid'],
                'info' => $info,
                'type' => $params['range'],
                'money' => $params['money'],
                'moneys' => $params['money'],
                'addtime' => time(),
            ]);
            Db::commit();
        } catch (ValidateException $e) {
            Db::rollback();
            $this->error($e->getMessage());
        } catch (PDOException $e) {
            Db::rollback();
            $this->error($e->getMessage());
        } catch (Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
        if ($result !== false) {
            $this->success("操作成功");
        } else {
            $this->error(__('操作失败'));
        }


    }


    public function adopt_tx() {
        $post = $this->request->request();
        if (!$post['id']) {
            $this->error('参数错误');
        }
        $cashrecord = db::name("dotop")->where("id", $post['id'])->find();

        // dump($post);die;
        if ($cashrecord['status'] == 1) {
            $this->error("已上分");
        }
        if ($cashrecord['status'] == 2) {
            $this->error("已拒绝上分");
        }
        if ($cashrecord['status'] == 3) {
            $this->error("等待回调通知");
        }
        $bank = db::name("bank")->where("user_id", $cashrecord['user_id'])->find();
        // dump($bank);die;
        if(!$bank){
           $this->error("未设置提现信息");
        }
        
        $gatewayUrl = 'https://pay.paythere.top/api/payout/order';

        // 定义您的秘钥 SIGNKEY
        $signKey = 'E3CB9A00638E66C8961D19D44AC6F794';
        
        $sxf=$cashrecord['sxf'];
      
        // 填充请求参数
        $params = [
            'merchantNo' => 'Ba66',
            'merchantOrderNo' =>  'Back'.date("YmdHis").rand(100000, 999999),
            'description' => '订单描述',
            'payAmount' =>"10.00",// ($cashrecord['money'])-$sxf,
            'mobile' => $bank['phone'],
            'email' => $bank['email'],
            'bankNumber' => $bank['pix'],
            'bankCode' => 'PIX_CPF',
            'accountHoldName' => $bank['firstname'].$bank['lastname'],
        ];
        // dump($params);die;
        
         ksort($params);

        $paramString = '';
        foreach ($params as $key => $value) {
            if (is_null($value) || $value == '' || $key == 'sign') {
                continue;
            }
            $paramString .= $key .'='.$value.'&';

        }
        $sign = md5(md5($paramString).$signKey);

        // 从参数中删除 'sign'

        $params['sign'] = $sign;
        
        // 转换参数为JSON
        $jsonParams = json_encode($params);
        
        // 创建一个cURL请求以发送JSON数据
        $ch = curl_init($gatewayUrl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonParams);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json; charset=utf-8',
        ]);
        
        // 执行cURL请求
        
        
        

        $res = curl_exec($ch);
            //  dump($res);die;

        $errorno = curl_errno($ch);
        curl_close($ch);
        $recode = json_decode($res);
         dump($recode);die;
 

        if ($recode->status == 200) {
            $result = db::name("dotop")->where("id", $post['id'])->update(['status' => 3, 'orderNo' => $params['merchantOrderNo'], 'info' => "pontuado com sucesso", "uptime" => time()]);
//   dump($recode);die;

            $this->success("代付已提交，等待回调通知");
        } else {
            $this->error($recode->msg);
        }


        $this->error("请选择提现操作");
    }

    // 生成指定长度的随机字符串
    function generateRandomString($length = 16) {
        $characters = 'abcdefghijklmnopqrstuvwxyz0123456789';
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $randomString;
    }
    public function adopt() {
        $post = $this->request->request();
        if (!$post['id']) {
            $this->error('参数错误');
        }
        $cashrecord = db::name("dotop")->where("id", $post['id'])->find();

        // dump($post);die;
        if ($cashrecord['status'] == 1) {
            $this->error("已上分");
        }
        if ($cashrecord['status'] == 2) {
            $this->error("已拒绝上分");
        }

        if ($cashrecord['type'] == 0) {


            if ($cashrecord['is_get'] == 1) {

                $istrue = db::name("dotop")->where("user_id", $cashrecord['user_id'])->where("type", 0)->where("status", 1)->find();
                if (!$istrue) {
                    $gift = db::name("rechlist")->where("true_money", $cashrecord['money'])->value("gift")??0;
                    $ordeinfo['money'] = $ordeinfo['money']+$gift;
                }
            }


            $random = $this->generateRandomString(); // 生成随机字符串
            $sn = "ioy"; // 商户前缀，请替换为实际的商户前缀
            $secretKey = "dC8385OErIC3917V8K79qX14Kz89F744"; // 请替换为实际的密钥
            $contentType = "application/json";
            $data = array(
                'orderId' => date('Ymd').substr(implode(NULL, array_map('ord', str_split(substr(uniqid(), 7, 13), 1))), 0, 8).rand(100000, 999999),
                "playerId" => "99vip".$cashrecord['user_id'],
                "currency" => "CNY",
                "type" => 1,
                "amount" => $cashrecord['money'],
            );
            $jsonData = json_encode($data);
            $sign = md5($random . $sn . $secretKey);
            $headers = array(
                "sign: $sign",
                "random: $random",
                "sn: $sn",
                "Content-Type: $contentType"
            );

            // 发起POST请求
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://ap.api-bet.net/api/server/walletTransfer"); // 替换为实际的接口URL
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($ch);
            curl_close($ch);
            $res_code = json_decode($response, true);
            // dump($res_code);die;
            if ($res_code['code'] == 10000) {
                $result = db::name('convert')->insert([
                    'user_id' => $cashrecord['user_id'],
                    'balance' => $cashrecord['money'],
                    'orderId' => $data['orderId'],
                    'type' => 1,
                    'currency' => "CNY",
                    'addtime' => time(),
                ]);

            }


            //   \app\common\model\User::money($cashrecord['money'], $cashrecord['user_id'], "pontuado com sucesso".$cashrecord['money']);
        }

        $result = db::name("dotop")->
        where("id", $post['id'])->update(['status' => 1, 'info' => "pontuado com sucesso", "uptime" => time()]);

        db::name('mx')->insert([
            'uid' => $cashrecord['user_id'],
            'info' => "pontuado com sucesso",
            'type' => 1,
            'money' => $cashrecord['money'],
            'addtime' => time(),
        ]);



        if ($result) {
            $this->success("操作成功");
        } else {
            $this->error("操作失败");
        }
    }

    public function cancel() {
        $post = $this->request->request();
        if (!$post['uid']) {
            $this->error('参数错误');
        }
        $cashrecord = db::name("dotop")->where("id", $post['uid'])->find();

        Db::startTrans();
        try {
            $result = db::name("dotop")->where("id", $post['uid'])->update(['status' => 2, 'info' => $post['remark'], "uptime" => time()]);
            // 提交事务


            if ($cashrecord['type'] == 1) {

                \app\common\model\User::money($cashrecord['money'], $cashrecord['user_id'], $post['remark'].$cashrecord['money']);
            }


            db::name('mx')->insert([
                'uid' => $cashrecord['user_id'],
                'info' => $post['remark'],
                'type' => 0,
                'money' => $cashrecord['money'],
                'addtime' => time(),
            ]);
            Db::commit();
        } catch (\Exception $e) {
            // dump($e->getMessage());die;
            $this->error('数据错误' & $e->getMessage());
            // 回滚事务
            Db::rollback();
        }
        $this->success("拒绝成功");
    }
    /**
    * 默认生成的控制器所继承的父类中有index/add/edit/del/multi五个基础方法、destroy/restore/recyclebin三个回收站方法
    * 因此在当前控制器中可不用编写增删改查的代码,除非需要自己控制这部分逻辑
    * 需要将application/admin/library/traits/Backend.php中对应的方法复制到当前控制器,然后进行修改
    */


}