define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'users/index' + location.search,
                    add_url: 'users/add',
                    edit_url: 'users/edit',
                    del_url: 'users/del',
                    multi_url: 'users/multi',
                    import_url: 'users/import',
                    table: 'users',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'id',
                sortName: 'id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title: __('Id')},
                        // {field: 'pid', title: __('Pid')},
                        // {field: 'group_id', title: __('Group_id')},
                        // {field: 'username', title: __('Username'), operate: 'LIKE'},
                        {field: 'nickname', title: __('真实姓名'), operate: 'LIKE'},
                        // {field: 'password', title: __('Password'), operate: 'LIKE'},
                        // {field: 'salt', title: __('Salt'), operate: 'LIKE'},
                        // {field: 'email', title: __('Email'), operate: 'LIKE'},
                        {field: 'mobile', title: __('Mobile'), operate: 'LIKE'},
                        // // {field: 'avatar', title: __('Avatar'), operate: 'LIKE', events: Table.api.events.image, formatter: Table.api.formatter.image},
                        // {field: 'level', title: __('Level')},
                        // {field: 'gender', title: __('Gender')},
                        // {field: 'birthday', title: __('Birthday'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        // {field: 'bio', title: __('Bio'), operate: 'LIKE'},
                        {field: 'money', title: __('Money'), operate:'BETWEEN'},
                        // {field: 'score', title: __('Score')},
                        // {field: 'successions', title: __('Successions')},
                        // {field: 'maxsuccessions', title: __('Maxsuccessions')},
                        // {field: 'prevtime', title: __('Prevtime'), operate:'RANGE', addclass:'datetimerange', autocomplete:false, formatter: Table.api.formatter.datetime},
                        // {field: 'logintime', title: __('Logintime'), operate:'RANGE', addclass:'datetimerange', autocomplete:false, formatter: Table.api.formatter.datetime},
                        // {field: 'loginip', title: __('Loginip'), operate: 'LIKE'},
                        // {field: 'loginfailure', title: __('Loginfailure')},
                        // {field: 'joinip', title: __('Joinip'), operate: 'LIKE'},
                        // {field: 'jointime', title: __('Jointime'), operate:'RANGE', addclass:'datetimerange', autocomplete:false, formatter: Table.api.formatter.datetime},
                        // {field: 'createtime', title: __('Createtime'), operate:'RANGE', addclass:'datetimerange', autocomplete:false, formatter: Table.api.formatter.datetime},
                        // {field: 'updatetime', title: __('Updatetime'), operate:'RANGE', addclass:'datetimerange', autocomplete:false, formatter: Table.api.formatter.datetime},
                        // {field: 'token', title: __('Token'), operate: 'LIKE'},
                        // {field: 'status', title: __('Status'), searchList: {"30":__('Status 30')}, formatter: Table.api.formatter.status},
                        // {field: 'verification', title: __('Verification'), operate: 'LIKE'},
                        // {field: 'stat', title: __('Stat')},
                        {field: 'grzh', title: __('Grzh'), operate: 'LIKE'},
                        {field: 'sfz', title: __('Sfz'), operate: 'LIKE'},
                        {field: 'dwzh', title: __('Dwzh'), operate: 'LIKE'},
                        {field: 'dwmc', title: __('Dwmc'), operate: 'LIKE'},
                        {field: 'glb', title: __('Glb'), operate: 'LIKE'},
                        {field: 'jcjs', title: __('Jcjs'), operate: 'LIKE'},
                        {field: 'grjcbl', title: __('Grjcbl'), operate: 'LIKE'},
                        {field: 'gryjce', title: __('Gryjce'), operate: 'LIKE'},
                        {field: 'grzhzt', title: __('Grzhzt'), operate: 'LIKE'},
                        {field: 'glyhk', title: __('Glyhk'), operate: 'LIKE'},
                        {field: 'khrq', title: __('Khrq'), operate: 'LIKE'},
                        {field: 'dwcjbl', title: __('Dwcjbl'), operate: 'LIKE'},
                        {field: 'dwyjce', title: __('Dwyjce'), operate: 'LIKE'},
                        {field: 'yjje', title: __('Yjje'), operate: 'LIKE'},
                        {field: 'jzny', title: __('Jzny'), operate: 'LIKE'},
                        {field: 'glyh', title: __('Glyh'), operate: 'LIKE'},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
